var Fullscreen = function(document, elementId) {
    this.elementId = elementId;
    this.document = document;

    if ('fullscreenEnabled' in this.document) {
        this.properties = {
            'fullscreenEnabled':  'fullscreenEnabled',
            'fullscreenElement':  'fullscreenElement',
            'onfullscreenchange': 'onfullscreenchange',
            'onfullscreenerror':  'onfullscreenerror',
            'exitFullscreen':     'exitFullscreen',
            'requestFullscreen':  'requestFullscreen'
        };
    } else if ('webkitFullscreenEnabled' in this.document) {
        this.properties = {
            'fullscreenEnabled':  'webkitFullscreenEnabled',
            'fullscreenElement':  'webkitFullscreenElement',
            'onfullscreenchange': 'onwebkitfullscreenchange',
            'onfullscreenerror':  'onwebkitfullscreenerror',
            'exitFullscreen':     'webkitExitFullscreen',
            'requestFullscreen':  'webkitRequestFullscreen'
        };
    } else if ('mozFullScreenEnabled' in this.document) {
        this.properties = {
            'fullscreenEnabled':  'mozFullScreenEnabled',
            'fullscreenElement':  'mozFullScreenElement',
            'onfullscreenchange': 'onmozfullscreenchange',
            'onfullscreenerror':  'onmozfullscreenerror',
            'exitFullscreen':     'mozCancelFullScreen',
            'requestFullscreen':  'mozRequestFullScreen'
        };
    } else if ('msFullscreenEnabled' in this.document) {
        this.properties = {
            'fullscreenEnabled':  'msFullscreenEnabled',
            'fullscreenElement':  'msFullscreenElement',
            'onfullscreenchange': 'MSFullscreenChange',
            'onfullscreenerror':  'MSFullscreenError',
            'exitFullscreen':     'msExitFullscreen',
            'requestFullscreen':  'msRequestFullscreen'
        };
    } else {
        this.properties = null;
    }

    if (this.properties) {
        this.fullscreenEnabled = this.document[this.properties['fullscreenEnabled']];
    }
}

Fullscreen.prototype.isSupported = function() {
    if (!this.properties) {
        return false;
    }

    return true;
}

Fullscreen.prototype.getFullscreenElement = function() {
    if (!this.properties) {
        return null;
    }

    return this.document[this.properties['fullscreenElement']];
}

Fullscreen.prototype.requestFullscreen = function() {
    if (!this.properties) {
        return;
    }

    this.elementId[this.properties['requestFullscreen']]();
}

Fullscreen.prototype.exitFullscreen = function() {
    if (!this.properties) {
        return;
    }

    this.document[this.properties['exitFullscreen']]();
}

Fullscreen.prototype.setOnFullscreenChange = function(functionImplementation) {
    if (!this.properties) {
        return;
    }

    this.document[this.properties['onfullscreenchange']] = functionImplementation;
}

Fullscreen.prototype.setOnFullscreenError = function(functionImplementation) {
    if (!this.properties) {
        return;
    }

    this.document[this.properties['onfullscreenerror']] = functionImplementation;
}
